# Vespucci 20.2 Highlights

2024-11-03

### Automatically generate summary of changes

Vespucci will now automatically add a summary of the edits made to the changeset tags. As this typically will be far more than what can be added to a single comment tag (max. 255 characters), it uses additional tags for this. If the comment tag is left empty it will add a comment referencing the automatically generated tags.

We further added an option on the "Properties" tab of the upload modal to reduce the nagging about filling out the comment field.

### Change of direction values handling

In 20.1 we added support for _direction_ tag handling including a specific modal for adding direction values, however we showed this for all direction values which was less than optimal. We've now added a further preset _value_type_ _cardinal_direction_ and will only show the direction modal for objects that match preset fields with that value.

### Support for _match_expression_ in presets

We now support the _match_expression_ attribute for preset items and fields (extension). This allows fine grained control of preset matching in cases for which the standard node, way closed way and relation matching isn't sufficient.

For example the _direction_ tag for _traffic_sign_ objects has different semantics depending on if the traffic sign is tagged on a way node of a _highway_ object, or if it is a stand alone traffic sign node (the relevant direction changes by 180°). Using match expressions allows to differentiate between these two cases.  

### Support for replacing geometries

We've added support for the most common "replace geometry" operations.

#### Replace node by way 

This operation will replace one of the way nodes with the node maintaining a link to the history and move and merge tags from the original node to the target way.

#### Replace way geometry with geometry of a source way

This operation will move the nodes of a target way to the positions of those in a source way, adding new and deleting existing nodes as necessary. Tagged way nodes that 
would have to be moved more than a configurable distance (default 1m) will be extracted from the way and replaced by a new node.

### Improve GPX recording behaviour when device is locked

Depending on device and Android version devices would pause GPX track recoding if the device was locked (aka screen turned off) leading to breaks in the recording (if you left the screen on or forced it on this wasn't an issue). We now acquire a partial wake lock when GPX recording is active which should avoid this issue. Note that this means that power consumption in such situations will be higher.

### Optionally use hardware rendering on Android 10 and later

Starting with Android 10, Androids graphic library supports all operations that we use for OSM data rendering, in particular the scaling issues that used to make it unusable seem to 
be fixed now, therefore we have re-enabled the support for it that you can turn on in the _Experimental_ section of the _Advanced Preferences_. Note that this will not make things 
blazingly fast, but it will allow use of graphics memory to store tiles and in general reduce some of the pressure on the JAVA heap. 

## Miscellaneous

- Add support for HEIC/HEIF images on Android 10 and later
- Remove hardwired suppression of icons on buildings, building:parts etc.
- Add traffic_sign to hardwired object tags
- Add a search box to the WMS layer modal
- Add multi-select for tag only editing mode
- Support automatically selecting overpass query results
- Add basic and parking amenity rendering for multipolygons
- Lock screen if last use is more than 24 hours ago
- Add image orientation to photo index
- Add use a JOSM filter expression to determine exceptions to reversing rules
- Re-factor locking in StorageDelegator to reduce (rare) dead locks.
- Fallback to network location is now disabled as default.

# Upgrading from previous versions

As a general precaution you should upload any pending changes before updating, particularly if you are upgrading from any major version that doesn't immediately precede this one. 

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
